/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.machine.analyser;

import binnie.core.machines.Machine;
import binnie.core.machines.power.ComponentProcessSetCost;
import binnie.core.machines.power.ErrorState;
import binnie.core.machines.power.IProcess;
import binnie.core.util.I18N;
import binnie.genetics.machine.analyser.Analyser;
import net.minecraft.item.ItemStack;

public class AnalyserComponentLogic
extends ComponentProcessSetCost
implements IProcess {
    public AnalyserComponentLogic(Machine machine) {
        super(machine, 9000, 300);
    }

    @Override
    public ErrorState canWork() {
        if (this.getUtil().isSlotEmpty(6)) {
            return new ErrorState.NoItem(I18N.localise("genetics.machine.analyser.error.noItem"), 6);
        }
        boolean analysed = Analyser.isAnalysed(this.getUtil().getStack(6));
        if (!analysed) {
            return super.canWork();
        }
        return new ErrorState.InvalidItem(I18N.localise("genetics.machine.analyser.error.alreadyAnalysed.title"), I18N.localise("genetics.machine.analyser.error.alreadyAnalysed"), 6);
    }

    @Override
    public ErrorState canProgress() {
        if (this.getUtil().getSlotCharge(13) != 0.0f) {
            return super.canProgress();
        }
        return new ErrorState.Item(I18N.localise("genetics.machine.analyser.error.insufficientDye.title"), I18N.localise("genetics.machine.analyser.error.insufficientDye"), new int[]{13});
    }

    @Override
    protected void onFinishTask() {
        super.onFinishTask();
        ItemStack itemStack = this.getUtil().getStack(6);
        itemStack = Analyser.analyse(itemStack);
        this.getInventory().func_70299_a(6, itemStack);
    }

    @Override
    protected void onTickTask() {
        this.getUtil().useCharge(13, 0.002f);
    }
}

